/**
 * @file
 * Views Share modal behavior.
 */

(function (Drupal, $) {
  Drupal.theme.viewsShareModal = function () {
    const closeText = Drupal.t('Close');
    // This markup is based on core dialog conventions.
    return `
      <div id="views-share-modal" class="dialog">
        <div class="dialog__header">
          <h2 class="dialog__title"></h2>
          <button type="button" class="dialog__close" aria-label="${closeText}">
            <span class="visually-hidden">${closeText}</span>
          </button>
        </div>
        <div class="dialog__content" id="views-share-modal-content"></div>
      </div>
    `;
  };
})(Drupal, jQuery);
