# Views Share

This module provides a Views area handler that, when added to your view, places a "Share" link on your view, which
enables an easy way to grab the URL of the view and share it via email, social media, or other means. It also provides
an embed code so that you can embed the view in another site via an iframe.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/views_share).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/views_share).


## Table of contents

- Requirements
- Recommended modules
- Installation
- Configuration
- Maintainers


## Requirements

This module requires no modules outside of Drupal core, but there are two that are recommended (see below).


## Recommended modules

Starting in Drupal 8, there is now a feature built into core that stops the site from being rendered within an iframe.
If you want your view to be embedded in another site via an iframe, you will need to add a contributed or custom
module. One such example is [Allow site iframing](https://www.drupal.org/project/allow_iframed_site). There is not
a current release that is Drupal 11 ready, but the DEV version is compatible with Drupal 11.

The module also has a built-in integration with [Shorten URLs](https://www.drupal.org/project/shorten). This allows
view share links to be shortened.

## Installation

Install as you would normally install a contributed Drupal module. For further information,
see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

1. Enable the module at Administration > Extend.
2. Add the "Share" area handler to your view. Area handlers can be added to the header or footer of a view.


## Maintainers

- Daniel Cothran - [andileco](https://www.drupal.org/u/andileco)
