/**
 * @file
 * Views Share form behavior.
 */

(function (Drupal, drupalSettings, $, once) {
  /**
   * Behavior for views share functionality.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches the behavior for views share.
   */
  Drupal.behaviors.viewsShare = {
    attach(context) {
      // Attach focus handler for share embed and link fields.
      once(
        'views-share-focus',
        '.views-share-embed, .views-share-link',
        context,
      ).forEach(function (element) {
        $(element).on('focus', function () {
          const that = this;
          setTimeout(function () {
            that.select();
          }, 100);
        });
      });

      // Attach click handler for preview links.
      once('views-share-preview', 'a.views-share-preview', context).forEach(
        function (element) {
          $(element).on('click', function (e) {
            e.preventDefault();

            // Open popup centered on screen.
            const width = 1024;
            const height = 768;
            const left = ($(window).width() - width) / 2;
            const top = ($(window).height() - height) / 2;
            const popup = window.open(
              $(this).attr('href'),
              'views-share-preview',
              `scrollbars=1,width=${width},height=${height},top=${top},left=${left}`,
            );

            // Listen for postMessage events from the popup.
            const eventMethod = window.addEventListener
              ? 'addEventListener'
              : 'attachEvent';
            const eventMessage =
              eventMethod === 'attachEvent' ? 'onmessage' : 'message';
            window[eventMethod](
              eventMessage,
              function (event) {
                document.getElementById('edit-share-embed').value =
                  event.data.embedCode;
              },
              false,
            );
          });
        },
      );

      // Attach click handler for short URL toggle.
      once('views-share-short-url', '[id^="edit-short-url"]', context).forEach(
        function (element) {
          $(element).on('click', function () {
            document.querySelector('[id^="edit-share-link"]').value = this
              .checked
              ? drupalSettings.viewsShare.shortURL
              : drupalSettings.viewsShare.originalURL;
          });
        },
      );
    },
  };
})(Drupal, drupalSettings, jQuery, once);
