/**
 * @file
 * Views Share preview behavior.
 */

(function (Drupal, drupalSettings, $, once) {
  /**
   * Behavior for Views Share Preview.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.viewsSharePreview = {
    attach(context) {
      // Attach a focus handler to the #edit-embed-share field.
      once('views-share-preview-focus', '#edit-embed-share', context).forEach(
        (element) => {
          $(element).on('focus', () => {
            // Delay selection by 100ms to ensure field is properly focused.
            setTimeout(() => {
              element.select();
            }, 100);
          });
        },
      );

      // Create an anchor element to derive a baseURI for postMessage.
      const a = document.createElement('a');
      a.href = window.location.href;

      // Attach a change handler to both width and height fields.
      once(
        'views-share-preview-change',
        '#edit-embed-width, #edit-embed-height',
        context,
      ).forEach((element) => {
        $(element).on('change', () => {
          const width = document.getElementById('edit-embed-width').value;
          const height = document.getElementById('edit-embed-height').value;

          // Get the current embed code directly from the textarea
          let embedCode = document.getElementById('edit-embed-share').value;

          // If no embed code exists yet, get it from the iframe in the preview
          if (!embedCode && $('.views-share-preview-wrapper iframe').length) {
            const iframe = $('.views-share-preview-wrapper iframe')[0];
            embedCode = iframe.outerHTML;
          }

          // Update dimensions in the style attribute if we have an embed code
          if (embedCode) {
            embedCode = embedCode.replace(/width:[^;]+;/, `width:${width}px;`);
            embedCode = embedCode.replace(
              /height:[^;]+;/,
              `height:${height}px;`,
            );

            // Update the embed code field
            document.getElementById('edit-embed-share').value = embedCode;

            // Replace any existing iframe in the preview
            $('.views-share-preview-wrapper iframe').replaceWith(embedCode);

            // Post the new embed code to the parent window if opener exists
            if (window.opener) {
              window.opener.postMessage({ embedCode }, a.baseURI);
            }
          }
        });
      });
    },
  };
})(Drupal, drupalSettings, jQuery, once);
