<?php

namespace Drupal\views_slider\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Swiper Slider library settings.
 */
class SwiperLibraryConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['views_slider.swiper_library_config'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'views_slider_swiper_library_config_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('views_slider.swiper_library_config');

    // Swiper version field, now always visible.
    $form['swiper_version'] = [
      '#type' => 'select',
      '#title' => $this->t('Swiper Version'),
      '#description' => $this->t('Choose the version of Swiper to load from the CDN. If Swiper is already being loaded by another module or theme, select "None" to prevent conflicts.'),
      '#options' => [
        '' => $this->t('None (do not load Swiper from the CDN)'),
        '11' => $this->t('Swiper Version 11'),
        '12' => $this->t('Swiper Version 12'),
      ],
      '#default_value' => $config->get('swiper_version') ?: '11',
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('views_slider.swiper_library_config')
      ->set('swiper_version', $form_state->getValue('swiper_version'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
