Views Slider
============

The **Views Slider** module provides a flexible way to display interactive
sliders directly from Views configuration in Drupal.

The module offers support for:

*   Custom field mapping (e.g., title, description, image, links)
*   Full theme override support using Twig, CSS, and custom templates

You can customize the slider's look to fit your needs and make it more
user-friendly with different layouts and themes.

For detailed documentation, visit the [project page](https://www.drupal.org/project/views_slider).

If you encounter issues or have suggestions, visit the [issue queue](https://www.drupal.org/project/issues/views_slider).

* * *

Table of Contents
-----------------

*   [Requirements](#requirements)
*   [Installation](#installation)
*   [Configuration](#configuration)
*   [Customization](#customization)
*   [Troubleshooting](#troubleshooting)
*   [Maintainers](#maintainers)

* * *

### Requirements

This module does not require any contributed modules outside of Drupal core.

* * *

### Installation

Install the module as you would any other contributed Drupal module.
For detailed instructions, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

**If using Composer:**

    composer require drupal/views_slider

**Enable the module using Drush:**

    drush en views_slider

* * *

### Configuration

To configure the Views Slider module:

1.  Navigate to: `Structure → Views → Add new view`
2.  Add required fields for slider heading, image, description, link 1, link 2,
and apply necessary updates (e.g., for image style configurations).
3.  Select the **Views Slider** format from the available View format options.
4.  Map the fields from your view to slider-specific fields (e.g., title,
description, image, link).
5.  If required, override the layout using custom Twig templates (e.g.,
copy `templates/views-view-views-slider.html.twig` to your theme).
6.  Save your view configuration.

You can configure which fields are displayed in the slider directly from
the view settings. The available options for configuration are:

*   Slider Heading
*   Slider Description 1
*   Slider Description 2
*   Slider Background Image
*   Slider Link 1
*   Slider Link 2

In addition to this, the Views Slider plugin provides options to control
Swiper JS settings and responsive behavior through the module
configuration form.

* * *

### Customization

For full customization of your slider:

*   Override the default Twig templates for specific layouts
(e.g., `templates/views-view-views-slider.html.twig`) by copying them
into your custom theme's folder.
*   Use custom CSS to adjust layout styles and presentation.
*   Modify the underlying HTML and CSS classes within the Twig templates
for advanced changes.

Follow Drupal's standard theming practices to override templates and
libraries via your theme or a custom module.

#### Swiper JS Library

The module automatically loads the Swiper JS library from a CDN, so you
don't need to worry about hosting the library yourself. You can configure
various Swiper JS settings directly from the module's configuration
form, including:

*   Slider Direction
*   Looping
*   Autoplay
*   Slide Transition Effect
*   Pagination and Navigation
*   Responsive Settings
*   Mousewheel and Keyboard Controls
*   Lazy Loading

* * *

### Configuration Form Overview

The Views Slider plugin allows you to configure various options through
the form settings. Below are key configurations available in the plugin:

#### General Settings

The general settings include options for customizing row classes, slider type,
and description.

#### Swiper JS Settings

Swiper JS settings allow you to control the visual behavior and transitions
of the slider, such as direction, speed, autoplay, pagination, and more.
The following are configurable options:

*   Swiper Direction
*   Loop
*   Slide Speed
*   Autoplay
*   Transition Effects
*   Navigation Arrows
*   Pagination
*   Keyboard Control
*   Mousewheel Control
*   Lazy Loading
*   Responsive Breakpoints

* * *

### Troubleshooting

*   Ensure Views are configured with valid fields and the data is
rendering correctly.
*   Verify that the layout is correctly overridden and that Twig templates are
placed in the correct theme location.
*   Check that custom CSS styles are applied and modify selectors as needed.
*   If color palettes are not displaying correctly, confirm that the palette
settings have been saved and applied properly.

* * *

### Maintainers

**Sujan Shrestha** - [sujan-shrestha](https://www.drupal.org/u/sujan-shrestha)

* * *

### Additional Notes

This module provides a basic CSS design layout. You need to configure
the heading, description, image, and other content with appropriate classes
according to the active theme. CSS can be customized based on design
requirements, such as navigation and pagination positioning, as well as
the display of image carousels,
sliders, and other layout components.
