(function ($, Drupal, drupalSettings) {
  Drupal.behaviors.swiperCustomBehavior = {
    attach: function (context, settings) {
      // Find all elements with the class .views-hero-slider and only initialize once per element
      once('swiper_custom', '.views-hero-slider', context).forEach(function (sliderElement) {

        // Ensure the slider element exists
        if (!sliderElement) {
          console.error('Swiper element .views-hero-slider not found.');
          return;
        }

        /**
         * Converts kebab-case-string to camelCaseString.
         * @param {string} s - The kebab-case string.
         * @returns {string} The camelCase string.
         */
        const toCamelCase = (s) => {
          return s.replace(/[-_]([a-z])/g, (match, char) => char.toUpperCase());
        };

        // Initialize configuration object
        let config = {};

        // Iterate over all data attributes of the slider element
        for (const attr of sliderElement.attributes) {
          if (attr.name.startsWith('data-swiper-config-')) {

            const fullKey = attr.name.replace('data-swiper-config-', '');
            const parts = fullKey.split('-');
            let value = attr.value;
            let parsedValue = value;

            // 1. Attempt to parse complex values (JSON objects/booleans/numbers)
            try {
              // Check if the value looks like a JSON object, array, boolean, or number
              if ((value.startsWith('{') && value.endsWith('}')) || (value.startsWith('[') && value.endsWith(']')) || value === 'true' || value === 'false' || !isNaN(value)) {
                parsedValue = JSON.parse(value);
              } else {
                // Handle simple boolean strings if not covered by JSON.parse
                if (value === 'true') {
                  parsedValue = true;
                } else if (value === 'false') {
                  parsedValue = false;
                }
              }
            } catch (e) {
              // If parsing fails, treat it as a raw string value
              parsedValue = value;
            }

            // 2. Build the nested configuration object dynamically (e.g., navigation-next-el)
            let currentLevel = config;
            for (let i = 0; i < parts.length; i++) {
              const key = toCamelCase(parts[i]);

              if (i === parts.length - 1) {
                // Last part of the key: set the final value
                currentLevel[key] = parsedValue;
              } else {
                // Intermediate key: ensure the object exists
                currentLevel[key] = currentLevel[key] || {};
                currentLevel = currentLevel[key];
              }
            }
          }
        }

        // 3. Final mapping adjustments for effect objects (e.g., 'coverflowEffect' -> 'coverflow')
        if (config.coverflowEffect) {
          config.coverflow = config.coverflowEffect;
          delete config.coverflowEffect;
        }
        if (config.fadeEffect) {
          config.fade = config.fadeEffect;
          delete config.fadeEffect;
        }

        // Initialize Swiper with the dynamically loaded configuration
        const swiper = new Swiper(sliderElement, config);

      });
    }
  };
})(jQuery, Drupal, drupalSettings);
