<?php

namespace Drupal\views_string_aggregation\Plugin\views\argument;

use Drupal\views\Attribute\ViewsArgument;
use Drupal\views\Plugin\views\argument\ArgumentPluginBase;

/**
 * Simple handler for arguments using string group by.
 *
 * @ingroup views_argument_handlers
 *
 * @property \Drupal\views\Plugin\views\query\Sql $query
 */
#[ViewsArgument(
  id: 'groupby_string',
)]
class GroupByString extends ArgumentPluginBase
{

  /**
   * {@inheritdoc}
   */
  public function query($group_by = FALSE)
  {
    $this->ensureMyTable();
    $field = $this->getField();
    $placeholder = $this->placeholder();

    $this->query->addHavingExpression($this->options['group'], "$field = $placeholder", [
      $placeholder => $this->value,
    ]);

  }

  /**
   * {@inheritdoc}
   */
  public function adminLabel($short = FALSE)
  {
    return $this->getField(parent::adminLabel($short));
  }

  /**
   * {@inheritdoc}
   */
  public function getSortName()
  {
    return $this->t('String', [], ['context' => 'Sort order']);
  }
}
