<?php

namespace Drupal\views_string_aggregation\Plugin\views\query;

use Drupal\views\Attribute\ViewsQuery;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Postgres STRING_AGG aggregation support.
 *
 * @ingroup views_query_plugins
 */
#[ViewsQuery(
  id: 'vsa_views_query_pgsql',
  no_ui: FALSE,
  title: new TranslatableMarkup('SQL Query with Postgres STRING_AGG'),
  help: new TranslatableMarkup('Query will be generated and run using the Drupal database API with Postgres STRING_AGG support.')
)]
class PgSql extends VsaBase {

  /**
   * String aggregation method callback for Postgres STRING_AGG.
   */
  public function vsaAggregationMethodSimple($group_type, $field): string {
    return 'STRING_AGG(' . $field . ', ' . $this->getSeparator() . $this->getOrderBy() . ')';
  }

  /**
   * String aggregation method callback for Postgres STRING_AGG with DISTINCT.
   */
  public function vsaAggregationMethodDistinct($group_type, $field): string {
    // Pass the field to getOrderBy to set it for this call.
    // This ensures the correct field is used in the ORDER BY clause.
    // as DISTINCT here does not support ordering by a different field in pgsql.
    return 'STRING_AGG(DISTINCT ' . $field . ', ' . $this->getSeparator() . $this->getOrderBy((string) $field) . ')';
  }

}
