<?php

namespace Drupal\views_string_aggregation\Plugin\views\argument;

use Drupal\views\Attribute\ViewsArgument;
use Drupal\views\Plugin\views\argument\ArgumentPluginBase;

/**
 * Simple handler for arguments using string group by.
 *
 * @ingroup views_argument_handlers
 *
 * @property \Drupal\views\Plugin\views\query\Sql $query
 */
#[ViewsArgument(
  id: 'groupby_string',
)]
class GroupByString extends ArgumentPluginBase {

  /**
   * {@inheritdoc}
   */
  public function query($group_by = FALSE) {
    $this->ensureMyTable();
    $field = $this->getField();

    // Get the argument value from the URL.
    $argument = $this->argument;

    // If no argument is provided, don't add any condition.
    if (empty($argument)) {
      return;
    }

    $placeholder = $this->placeholder();
    $connection = $this->query->getConnection();

    $this->query->addHavingExpression($this->options['group_type'], "$field LIKE $placeholder", [
      $placeholder => '%' . $connection->escapeLike($argument) . '%',
    ]);
  }

  /**
   * {@inheritdoc}
   */
  public function adminLabel($short = FALSE) {
    return $this->getField(parent::adminLabel($short));
  }

  /**
   * {@inheritdoc}
   */
  public function getSortName() {
    return $this->t('String', [], ['context' => 'Sort order']);
  }

}
