<?php

namespace Drupal\views_string_aggregation\Plugin\views\query;

use Drupal\views\Attribute\ViewsQuery;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * MySQL/MariaDB GROUP_CONCAT aggregation support.
 *
 * @ingroup views_query_plugins
 */
#[ViewsQuery(
  id: 'vsa_views_query_mysql',
  title: new TranslatableMarkup('SQL Query with MySQL/MariaDB GROUP_CONCAT'),
  help: new TranslatableMarkup('Query will be generated and run using the Drupal database API with MySQL/MariaDB GROUP_CONCAT support.')
)]
class MySql extends VsaBase {

  /**
   * String aggregation method callback for MySql/MariaDB GROUP_CONCAT.
   */
  public function vsaAggregationMethodSimple($group_type, $field): string {
    return 'GROUP_CONCAT(' . $field . $this->getOrderBy() . ' SEPARATOR ' . $this->getSeparator() . ')';
  }

  /**
   * String aggregation method callback for MySql/MariaDB DISTINCT GROUP_CONCAT.
   */
  public function vsaAggregationMethodDistinct($group_type, $field): string {
    return 'GROUP_CONCAT(DISTINCT ' . $field . $this->getOrderBy() . ' SEPARATOR ' . $this->getSeparator() . ')';
  }

}
