<?php

namespace Drupal\views_string_aggregation\Plugin\views\query;

use Drupal\views\Attribute\ViewsQuery;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * SQLite GROUP_CONCAT aggregation support.
 *
 * @ingroup views_query_plugins
 */
#[ViewsQuery(
  id: 'vsa_views_query_sqlite',
  title: new TranslatableMarkup('SQL Query with SQLite GROUP_CONCAT'),
  help: new TranslatableMarkup('Query will be generated and run using the Drupal database API with SQLite GROUP_CONCAT support.')
)]
class Sqlite extends VsaBase {

  /**
   * String aggregation method callback for SQLite GROUP_CONCAT syntax.
   */
  public function vsaAggregationMethodSimple($group_type, $field): string {
    return 'GROUP_CONCAT(' . $field . ', ' . $this->getVsaSeparator() . $this->getVsaOrderBy() . ')';
  }

  /**
   * String aggregation method callback for SQLite DISTINCT GROUP_CONCAT syntax.
   */
  public function vsaAggregationMethodDistinct($group_type, $field): string {
    // SQLite does not yet support a custom separator with DISTINCT.
    // but we can still support ordering.
    return 'GROUP_CONCAT(DISTINCT ' . $field . $this->getVsaOrderBy() . ')';
  }

}
