/**
 * @file
 * Vat.
 */

(function ($, Drupal, drupalSettings) {
  Drupal.behaviors.views_table_filter = {
    attach: function (context, settings) {
      if (settings['views_table_filter']) {
        for (var view in settings['views_table_filter']) {
          var form = $('input.views-table-filter[value="' + view + '"]').eq(0).closest('form');
          if (form.length > 0) {
            const elements = once('views-table-filter', '.table-header-filter');
            if (elements.length > 0) {
              elements.forEach(process_view);
            }
          }
        }
      }

      function process_view(element) {
        var header_widget_wrapper = $(element);
        var classes = header_widget_wrapper.attr('class').split(' ');

        for (var i in classes) {
          if (/^table-header-filter-/.test(classes[i])) {
            var filter = classes[i].replace(/^table-header-filter-/, '');
            var name = settings['views_table_filter'][view][filter];

            if (!name) {
              continue;
            }
            var input = form.find('[name="' + name + '"],[name="' + name + '[]"],[name="' + name + '[value][date]"]');
            var widget = input.eq(0).closest('.form-item');

            if (widget.length < 1) {
              continue;
            }

            var widget_clone = widget.clone(true);

            widget_clone.show();

            widget_clone.find('[id]').each(add_id_suffix);
            widget_clone.find('label').hide();
            var input_clone = widget_clone.find('[name="' + name + '"],[name="' + name + '[]"],[name="' + name + '[value][date]"]');

            input_clone.change(function () {
              input.val(input_clone.val());
              input.change();
            });
            input_clone.keyup(function () {
              setTimeout(function () {
                input.val(input_clone.val());
              }, 100);
            });

            header_widget_wrapper.append(widget_clone);
            widget.hide();
          }
        }
      }

      function add_id_suffix() {
        var element = $(this);
        element.attr('id', element.attr('id') + '-views-table-filter');
      }
    }
  };
})(jQuery, Drupal, drupalSettings);
