<?php

namespace Drupal\views_themeable_text_area\Plugin\views\area;

use Drupal\Core\Form\FormStateInterface;
use Drupal\views\Attribute\ViewsArea;
use Drupal\views\Plugin\views\area\Text;

/**
 * Themeable views area text handler.
 */
#[ViewsArea("themeable_text_area")]
class ThemeableText extends Text {

  /**
   * {@inheritdoc}
   */
  protected function defineOptions() {
    $options = parent::defineOptions();
    $options['classes'] = ['default' => ''];
    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {
    parent::buildOptionsForm($form, $form_state);

    $form['classes'] = [
      '#title' => $this->t('Classes'),
      '#type' => 'textfield',
      '#description' => $this->t('Specify CSS classes to apply to the text area. Separate multiple classes with spaces.'),
      '#default_value' => $this->options['classes'],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function render($empty = FALSE) {
    $format = $this->options['content']['format'] ?? filter_default_format();

    if (!$empty || !empty($this->options['empty'])) {
      return [
        '#theme' => 'views_themeable_text_area',
        '#view' => $this->view,
        '#area' => $this,
        '#content' => [
          '#type' => 'processed_text',
          '#text' => $this->tokenizeValue($this->options['content']['value']),
          '#format' => $format,
        ],
      ];
    }

    return [];
  }

}
