<?php

namespace Drupal\views_themeable_text_area\Plugin\views\area;

use Drupal\Core\Form\FormStateInterface;
use Drupal\views\Attribute\ViewsArea;
use Drupal\views\Plugin\views\area\TextCustom;

/**
 * Themeable views area text handler.
 */
#[ViewsArea("themeable_text_area_custom")]
class ThemeableTextCustom extends TextCustom {

  /**
   * {@inheritdoc}
   */
  protected function defineOptions() {
    $options = parent::defineOptions();
    $options['classes'] = ['default' => ''];
    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {
    parent::buildOptionsForm($form, $form_state);

    $form['classes'] = [
      '#title' => $this->t('Classes'),
      '#type' => 'textfield',
      '#description' => $this->t('Specify CSS classes to apply to the text area. Separate multiple classes with spaces.'),
      '#default_value' => $this->options['classes'],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function render($empty = FALSE) {
    if (!$empty || !empty($this->options['empty'])) {
      return [
        '#theme' => 'views_themeable_text_area',
        '#view' => $this->view,
        '#area' => $this,
        '#content' => [
          '#markup' => $this->renderTextarea($this->options['content']),
        ],
      ];
    }

    return [];
  }

}
