<?php

namespace Drupal\Tests\views_tools\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests Views Tools permissions functionality.
 *
 * @group views_tools
 */
class ViewsToolsPermissionsTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = ['views_tools', 'views', 'views_ui', 'node'];

  /**
   * Test users with different permission levels.
   *
   * @var array
   */
  protected $testUsers = [];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Create users with different permission combinations.
    $this->testUsers['basic'] = $this->drupalCreateUser(['use views tools']);
    $this->testUsers['export'] = $this->drupalCreateUser(['use views tools', 'export views']);
    $this->testUsers['delete'] = $this->drupalCreateUser(['use views tools', 'delete view displays']);
    $this->testUsers['admin'] = $this->drupalCreateUser(['administer views tools']);
    $this->testUsers['views_admin'] = $this->drupalCreateUser(['administer views']);
  }

  /**
   * Tests basic access permissions.
   */
  public function testBasicAccess() {
    // Test anonymous user cannot access.
    $this->drupalGet('/admin/structure/views-tools');
    $this->assertSession()->statusCodeEquals(403);

    // Test basic user can access main page.
    $this->drupalLogin($this->testUsers['basic']);
    $this->drupalGet('/admin/structure/views-tools');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('Views Tools');
  }

  /**
   * Tests export permissions.
   */
  public function testExportPermissions() {
    // User with export permission should see export functionality.
    $this->drupalLogin($this->testUsers['export']);
    $this->drupalGet('/admin/structure/views-tools');
    $this->assertSession()->statusCodeEquals(200);

    // Basic user should not see export options.
    $this->drupalLogin($this->testUsers['basic']);
    $this->drupalGet('/admin/structure/views-tools');
    $this->assertSession()->statusCodeEquals(200);
  }

  /**
   * Tests admin permissions.
   */
  public function testAdminPermissions() {
    // Admin user should have access to everything.
    $this->drupalLogin($this->testUsers['admin']);
    $this->drupalGet('/admin/structure/views-tools');
    $this->assertSession()->statusCodeEquals(200);

    // Views admin should also have full access.
    $this->drupalLogin($this->testUsers['views_admin']);
    $this->drupalGet('/admin/structure/views-tools');
    $this->assertSession()->statusCodeEquals(200);
  }

}
