<?php

/**
 * @file
 * Definition of mymodule_handler_handlername.
 */

/**
 * Filters by day of the week of the supplied date argument.
 */
class views_weekday_handler_argument extends views_handler_argument_date {

  /**
   * Add an option to set the default value to the current date.
   */
  public function default_argument_form(&$form, &$form_state): void {
    parent::default_argument_form($form, $form_state);
    unset(
      $form['default_argument_type']['#options']['node'],
      $form['default_argument_type']['#options']['taxonomy_tid'],
      $form['default_argument_type']['#options']['user'],
      $form['default_argument_type']['#options']['current_user'],
    );
    $form['default_argument_type']['#options'] += ['date' => t('Current date')];
    $form['default_argument_type']['#options'] += ['node_created' => t("Current node's creation time")];
    $form['default_argument_type']['#options'] += ['node_changed' => t("Current node's update time")];
    $form['argument_default']['fixed']['#description'] = t('Enter a date string understood by the PHP date() function, such as "2025-09-18", "today", "1 March", or "Wednesday"');
  }

  /** @noinspection PhpPossiblePolymorphicInvocationInspection */
  public function query($group_by = FALSE): void {
    $this->ensure_my_table();
    $this->formula = "DAYOFWEEK($this->table.$this->real_field) = :dow";
    try {
      $date = new DateTime($this->argument);
      $dow = (int) $date->format('w') + 1;
      $this->query->add_where_expression($this->options['group'], $this->formula, [':dow' => $dow]);
    }
    catch (DateMalformedStringException $e) {
      watchdog_exception('views_weekday', $e);
    }
  }

}
