<?php

/**
 * Implements hook_views_data_alter().
 *
 * For basic drupal date fields.
 *
 * See: https://api.drupal.org/api/views/views.api.php/function/hook_views_data_alter/7.x-3.x
 *
 * @noinspection PhpUnused
 * @noinspection PhpUnusedLocalVariableInspection
 */
function views_weekday_views_data_alter(&$data): void {
  // Loops through fields definitions looking for date fields
  // and copies to create a new weekday date filter option.
  foreach ($data as $module => $table) {
    foreach ($table as $id => $field) {
      if (isset($field['field']['is date']) && $field['field']['is date']) {
        //$field['field']['filter'] = 'views_weekday_handler_filter';
        $group = $field['group'] ?? $table['table']['group'];
        $data[$module][$id . '_weekday'] = [
          'title' => $group . ': ' . $field['title'] . ' (' . $id . ')',
          'help' => $field['help'],
          'group' => t('Weekday'),
          'real field' => $field['field']['real field'] ?? $id,
          'argument' => [
            'handler' => 'views_weekday_handler_argument',
            'help' => t('Filter using the day of the week of the supplied date-string argument.'),
            'is date' => TRUE,
          ],
          'filter' => [
            'handler' => 'views_weekday_handler_filter',
            'is date' => TRUE,
          ],
        ];
      }
    }
  }
}

