# Vipps Login for Drupal
*This project is based on [Social API](https://www.drupal.org/project/social_api) and [Social Auth](https://www.drupal.org/project/social_auth).*

The module lets you login to Drupal using your Vipps app. It’s a secure and reliable way to handle user authentication, brought to you by the company that owns BankID.

See how it works in this video: ...

## Table of contents

* [ Requirements ](#requirements)
* [ Getting started ](#getting-started)
  * [ Installation ](#installation)
  * [ Configuration](#configuration)
* [ Extending the module ](#extending-the-module)
* [ Frequently Asked Questions ](#frequently-asked-questions)

## Requirements
* Drupal 8.x
* [Social API](https://www.drupal.org/project/social_api)
* [Social Auth](https://www.drupal.org/project/social_auth)
* Working Vipps account (see below)
## Getting started
* Sign up to use (Vipps på Nett)
* After 1-2 days you will get an email with login details to Vipps Developer Portal. This is where you can retrieve the API credentials used to configure the module in Drupal.
* Proceed to "Installation" below
### Installation
* Install dependencies
* Install the module

If you install the module using Composer, the dependencies will be added automatically:

`composer require "drupal/vipps_login"`

## Frequently Asked Questions
### How can I get help if I have any issues?

First, check out the documentation pages for the module on Drupal.org. If you still have issues, please create an issue in the issue queue for the module.

### Where can I use Vipps?

Vipps is only available in Norway at the moment and only users who have the Vipps app installed will be able to log in with Vipps.
