<?php

namespace Drupal\vipps_mobilepay_login\ParamConverter;

use Drupal\social_auth\ParamConverter\NetworkConverter;
use Drupal\social_auth\Plugin\Network\NetworkInterface;

/**
 * Provides upcasting for a network instance.
 *
 * @package Drupal\vipps_mobilepay_login\ParamConverter
 */
class VippsNetworkConverter extends NetworkConverter {

  /**
   * {@inheritdoc}
   */
  public function convert($value, $definition, $name, array $defaults): ?NetworkInterface {
    if ($value !== 'vipps') {
      return parent::convert($value, $definition, $name, $defaults);
    }
    $plugin_id = 'vipps_mobilepay_login';
    if ($this->networkManager->hasDefinition($plugin_id)) {
      /** @var \Drupal\vipps_mobilepay_login\Plugin\Network\VippsAuthInterface $param */
      $param = $this->networkManager->createInstance($plugin_id);
      return $param;
    }
    return NULL;
  }

}
