<?php

namespace Drupal\vipps_mobilepay_login\Settings;

use Drupal\social_auth\Settings\SettingsInterface;

/**
 * Defines an interface for Vipps MobilePay Login settings.
 */
interface VippsAuthSettingsInterface extends SettingsInterface {

  /**
   * Gets the Merchant Serial Number.
   *
   * @return string|null
   *   The Merchant Serial Number.
   */
  public function getMerchantSerialNumber(): ?string;

  /**
   * Gets the Subscription Key.
   *
   * @return string|null
   *   The Subscription Key.
   */
  public function getSubscriptionKey(): ?string;

}
