<?php

namespace Drupal\vipps_mobilepay_login\Settings;

use Drupal\social_auth\Settings\SettingsBase;
use Drupal\vipps_mobilepay\Entity\VippsMobilepayConnection;
use Drupal\vipps_mobilepay_login\VippsMobilepayHelperTrait;

/**
 * Defines methods to get Vipps MobilePay Login settings.
 */
class VippsAuthSettings extends SettingsBase implements VippsAuthSettingsInterface {

  use VippsMobilepayHelperTrait;

  /**
   * Merchant Serial Number.
   *
   * @var string|null
   */
  protected ?string $merchantSerialNumber = NULL;

  /**
   * Subscription Key.
   *
   * @var string|null
   */
  protected ?string $subscriptionKey = NULL;

  /**
   * Returns the connection profile.
   *
   * @return \Drupal\vipps_mobilepay\Entity\VippsMobilepayConnection|null
   *   The connection profile.
   */
  public function getConnectionProfile(): ?VippsMobilepayConnection {
    if (!$this->config->get('connection_profile')) {
      return NULL;
    }
    return $this->loadConnectionProfile($this->config->get('connection_profile'));
  }

  /**
   * {@inheritdoc}
   */
  public function getClientId(): ?string {
    if (!$this->clientId) {
      $connection_profile = $this->getConnectionProfile();
      $this->clientId = $connection_profile->get('client_id');
    }
    return $this->clientId;
  }

  /**
   * {@inheritdoc}
   */
  public function getClientSecret(): ?string {
    if (!$this->clientSecret) {
      $connection_profile = $this->getConnectionProfile();
      $this->clientSecret = $connection_profile->get('client_secret');
    }
    return $this->clientSecret;
  }

  /**
   * {@inheritdoc}
   */
  public function getMerchantSerialNumber(): ?string {
    if (!$this->merchantSerialNumber) {
      $connection_profile = $this->getConnectionProfile();
      $this->merchantSerialNumber = $connection_profile->get('merchant_serial_number');
    }
    return $this->merchantSerialNumber;
  }

  /**
   * {@inheritdoc}
   */
  public function getSubscriptionKey(): ?string {
    if (!$this->subscriptionKey) {
      $connection_profile = $this->getConnectionProfile();
      $this->subscriptionKey = $connection_profile->get('subscription_key');
    }
    return $this->subscriptionKey;
  }

}
