<?php

namespace Drupal\vipps_mobilepay_login;

/**
 * Implements Vipps MobilePay Helper trait.
 */
trait VippsMobilepayHelperTrait {

  /**
   * Vipps Connection profile.
   *
   * @var \Drupal\vipps_mobilepay\Entity\VippsMobilepayConnection|null
   */
  protected $connectionProfile;

  /**
   * Returns Vipps MobilePay Connection Profile.
   *
   * @param string $connection_profile_id
   *   Connection profile ID.
   *
   * @return \Drupal\vipps_mobilepay\Entity\VippsMobilepayConnection|null
   *   Vipps MobilePay Connection Profile.
   */
  public function loadConnectionProfile(string $connection_profile_id) {
    if (!$this->connectionProfile) {
      $this->connectionProfile = \Drupal::entityTypeManager()
        ->getStorage('vipps_mobilepay_connection')
        ->load($connection_profile_id);
    }
    return $this->connectionProfile;
  }

}
