<?php

namespace Drupal\Tests\vipps_mobilepay_login\Functional;

use Drupal\Tests\social_auth\Functional\SocialAuthTestBase;
use Drupal\vipps_mobilepay\Entity\VippsMobilepayConnection;

/**
 * Test Vipps Mobilepay Login settings form.
 *
 * @group social_auth
 *
 * @ingroup vipps_mobilepay_login
 */
class VippsMobilepayLoginSettingsFormTest extends SocialAuthTestBase {

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = ['vipps_mobilepay', 'vipps_mobilepay_login'];

  /**
   * A Vipps Mobilepay Connection profile.
   *
   * @var \Drupal\vipps_mobilepay\VippsMobilepayConnectionInterface
   */
  protected $connectionProfile;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    $this->module = 'vipps_mobilepay_login';
    $this->provider = 'vipps';
    $this->moduleType = 'social-auth';

    parent::setUp();

    $connection_profile = VippsMobilepayConnection::create([
      'id' => 'vipps_mobilepay_login_test',
      'label' => 'Vipps Mobilepay Login Test',
      'market' => 'NO',
      'mode' => 'test',
      'client_id' => $this->randomString(10),
      'client_secret' => $this->randomString(10),
      'subscription_key' => $this->randomString(10),
      'merchant_serial_number' => $this->randomString(5),
      'status' => 1,
    ]);
    $connection_profile->save();
    $this->connectionProfile = $connection_profile;
  }

  /**
   * Test if implementer is shown in the integration list.
   */
  public function testIsAvailableInIntegrationList() {
    $this->fields = ['connection_profile', 'partner_mode'];

    $this->checkIsAvailableInIntegrationList();
  }

  /**
   * Test if permissions are set correctly for settings page.
   */
  public function testPermissionForSettingsPage() {
    $this->checkPermissionForSettingsPage();
  }

  /**
   * Test settings form submission.
   */
  public function testSettingsFormSubmission() {
    $this->edit = [
      'connection_profile' => $this->connectionProfile->id(),
      'partner_mode' => 1,
    ];

    $this->checkSettingsFormSubmission();
  }

}
