# Data Migration

Guide for migrating analytics data between versions and from other analytics systems.

## Migration Scenarios

### Upgrading from Visitors 2.x to 3.x
The module provides automated migration paths for existing installations.

#### Database Schema Updates
- Automatic schema updates via update hooks
- Data preservation during upgrades
- New field additions with default values

#### Migration Process
```bash
# Backup existing data
drush sql:dump --result-file=visitors_backup.sql

# Run updates
drush updatedb

# Run Visitors upgrade (if migrating from 2.x)
drush visitors:upgrade
```

### Available Drush Commands

The Visitors module provides the following drush commands:

#### `drush visitors:upgrade`
**Purpose**: Upgrade data from Visitors 8.x-2.x to 3.0.x
**Usage**: `drush visitors:upgrade`
**Alias**: `drush visitors-upgrade`

This command migrates existing visitor data to the new schema format and should be run after upgrading from older versions.

#### Command Output
The upgrade command provides:
- Progress bar showing migration status
- Real-time feedback on records processed
- Completion confirmation when finished

### Custom Migration Scripts
For complex migrations or custom analytics systems, you can create custom migration scripts.

## Data Integrity

### Validation Checks
- Data consistency verification
- Foreign key constraint validation
- Statistical accuracy checks

### Rollback Procedures
- Database restoration from backups
- Selective data rollback options
- Migration status tracking

For technical migration details, see [Database Tables](tables.md).
