# Charts Integration

Configure visual analytics with the Charts module and Chart.js library.

## Overview

The Visitors module integrates with the Drupal Charts module to provide interactive visualizations of your analytics data.

## Installation

### Charts Module
```bash
composer require drupal/charts
drush pm:install charts charts_chartjs
```

### Configuration
1. Navigate to `/admin/config/content/charts`
2. Select Chart.js as the default library
3. Configure default chart settings

## Available Charts

### Visitor Trends
- Line charts showing visitor activity over time
- Daily, weekly, and monthly trend analysis
- Comparative period analysis

### Geographic Distribution
- Country and region distribution pie charts
- World map visualizations (with mapping libraries)
- Geographic heat maps

### Technical Analytics
- Browser usage pie charts
- Device type distribution
- Operating system statistics

### Performance Charts
- Page load time trends
- Server response time analysis
- Performance metric comparisons

## Custom Chart Creation

### Using Views
1. Create Views with Visitors data
2. Add Charts display
3. Configure chart type and styling
4. Embed in pages or blocks

### Programmatic Charts
```php
// Example chart creation
$chart = [
  '#type' => 'chart',
  '#chart_type' => 'line',
  '#title' => 'Daily Visitors',
  '#data' => $visitor_data,
];
```


