<?php

namespace Drupal\visitors\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a Visitors Event attribute.
 *
 * Plugin Namespace: Plugin\VisitorsEvent.
 *
 * @see \Drupal\visitors\VisitorsEventPluginManager
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class VisitorsEvent extends Plugin {

  /**
   * Constructs a VisitorsEvent attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|string|null $label
   *   The human-readable name of the plugin.
   * @param string|null $plugin
   *   The plugin name that generated this event.
   * @param array $variables
   *   Array of variables (up to 4) associated with this event.
   * @param int $weight
   *   The weight of the event (lower numbers appear earlier).
   * @param class-string|null $deriver
   *   (optional) The deriver class for this plugin.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup|string|null $label = NULL,
    public readonly ?string $plugin = NULL,
    public readonly array $variables = [],
    public readonly int $weight = 0,
    public readonly ?string $deriver = NULL,
  ) {}

}
