<?php

declare(strict_types=1);

namespace Drupal\visitors\Service;

use Drupal\visitors\VisitorsSocialNetworksInterface;

/**
 * Service for matching hostnames to social networks.
 */
final class SocialNetworksService extends HostnameMatcherServiceBase implements VisitorsSocialNetworksInterface {

  /**
   * {@inheritdoc}
   */
  protected function getConfig(): array {
    if ($this->cachedConfig === NULL) {
      $config = $this->configFactory->get('visitors.social_networks');
      $this->cachedConfig = $config ? $config->get('sites') ?? [] : [];
    }

    return $this->cachedConfig;
  }

}
