<?php

declare(strict_types=1);

namespace Drupal\visitors;

/**
 * Interface for visitors AI assistants service.
 */
interface VisitorsAiAssistantsInterface {

  /**
   * Match a hostname to an AI assistant.
   *
   * @param string $hostname
   *   The hostname to match.
   *
   * @return string|null
   *   The AI assistant label if matched, null otherwise.
   */
  public function match(string $hostname): ?string;

}
