<?php

namespace Drupal\visitors;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Interface for visitors event plugins.
 */
interface VisitorsEventPluginInterface extends PluginInspectionInterface {

  /**
   * Gets the event label.
   *
   * @return string
   *   The event label.
   */
  public function getLabel(): string;

  /**
   * Gets the plugin name that generated this event.
   *
   * @return string
   *   The plugin name.
   */
  public function getPlugin(): string;

  /**
   * Processes the event.
   *
   * @param array $context
   *   The context array containing:
   *   - visit_id: The visit ID
   *   - page_view: The unique page view ID
   *   - title: The page title
   *   - url: The page URL
   *   - path: The Drupal path
   *   - route: The route name
   *   - referrer_url: The referrer URL
   *   - uid: The user ID.
   *
   * @return array|null
   *   NULL if the plugin does not apply to the current context,
   *   otherwise an array with the following structure:
   *   - event: The plugin event.
   *   - variables: The plugin variables.
   */
  public function process(array $context): ?array;

  /**
   * Gets the weight of the event.
   *
   * @return int
   *   The weight of the event.
   */
  public function getWeight(): int;

}
