<?php

namespace Drupal\Tests\visitors\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the visitors/{report} page.
 *
 * @group visitors
 * @coversDefaultClass \Drupal\visitors\Controller\Report\ReportController
 * @uses \Drupal\visitors\Controller\Report\ReportController
 */
class VisitorsViewTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = ['visitors', 'node'];

  /**
   * Tests the html head links.
   *
   * @covers ::performance
   * @covers ::location
   * @covers ::device
   * @covers ::software
   * @covers ::time
   * @covers ::topHost
   * @covers ::path
   * @covers ::recentHost
   */
  public function testHasReportAccess() {
    $user = $this->drupalCreateUser([
      'access visitors',
    ]);
    $this->drupalLogin($user);

    $this->visitReports(200);
  }

  /**
   * Tests the Link header.
   *
   * @covers ::performance
   * @covers ::location
   * @covers ::device
   * @covers ::software
   * @covers ::time
   * @covers ::topHost
   * @covers ::path
   * @covers ::recentHost
   */
  public function testNoReportAccess() {
    $user = $this->drupalCreateUser([]);
    $this->drupalLogin($user);

    $this->visitReports(403);
  }

  /**
   * Tests Visitors Settings form access.
   *
   * @covers \Drupal\visitors\Form\SettingsForm::buildForm
   */
  public function testVisitorsSettingsForm403() {
    $user = $this->drupalCreateUser([]);
    $this->drupalLogin($user);
    $this->drupalGet('/admin/config/system/visitors');
    $this->assertSession()->statusCodeEquals(403);
  }

  /**
   * Tests Visitors Settings form access.
   *
   * @covers \Drupal\visitors\Form\SettingsForm::buildForm
   */
  public function testVisitorsSettingsForm200() {
    $user = $this->drupalCreateUser([
      'administer site configuration',
    ]);
    $this->drupalLogin($user);
    $this->drupalGet('/admin/config/system/visitors');
    $this->assertSession()->statusCodeEquals(200);
  }

  /**
   * Tests that we store and retrieve multi-byte UTF-8 characters correctly.
   */
  protected function visitReports(int $status) {
    $this->drupalGet('/admin/visitors');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/behavior/host');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/behavior/host/172.19.0.1');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/visit/hits');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/acquisition/referrers');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/behavior/path');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/behavior/path-entry');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/behavior/path-exit');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/behavior/route');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/behavior/route/visitors.hosts');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/behavior/route-entry');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/behavior/route-exit');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/behavior/performance');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/visit/location');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/visit/location/continent/_none');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/visit/location/country/_none');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/visit/location/region/_none/_none');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/visit/location/city/_none/_none/_none');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/visit/device');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/visit/software');
    $this->assertSession()->statusCodeEquals($status);

    $this->drupalGet('/admin/visitors/visit/times');
    $this->assertSession()->statusCodeEquals($status);
  }

}
