<?php

declare(strict_types=1);

namespace Drupal\Tests\visitors\Unit\Helper;

use Drupal\Tests\UnitTestCase;
use Drupal\visitors\Helper\VisitorsUrl;

/**
 * Tests the VisitorsUrl class.
 *
 * @coversDefaultClass \Drupal\visitors\Helper\VisitorsUrl
 * @uses \Drupal\visitors\Helper\VisitorsUrl
 * @group visitors
 */
class VisitorsUrlTest extends UnitTestCase {

  /**
   * Tests the getPrefix method.
   *
   * @covers ::getPrefix
   * @covers ::__construct
   * @dataProvider providerTestGetPrefix
   */
  public function testGetPrefix($url, $expected) {
    $visitors_url = new VisitorsUrl($url);
    $this->assertEquals($expected, $visitors_url->getPrefix());
  }

  /**
   * Data provider for testGetPrefix.
   */
  public static function providerTestGetPrefix() {
    return [
      ['http://www.example.com', 1],
      ['http://example.com', 0],
      ['https://www.example.com', 3],
      ['https://example.com', 2],
      ['ftp://example.com', NULL],
    ];
  }

  /**
   * Tests the getUrl method.
   *
   * @covers ::getUrl
   * @dataProvider providerTestGetUrl
   */
  public function testGetUrl($url, $expected) {
    $visitors_url = new VisitorsUrl($url);
    $this->assertEquals($expected, $visitors_url->getUrl());
  }

  /**
   * Data provider for testGetPrefix.
   */
  public static function providerTestGetUrl() {
    return [
      ['http://www.example.com', 'example.com'],
      ['http://example.com', 'example.com'],
      ['https://www.example.com', 'example.com'],
      ['https://example.com', 'example.com'],
      ['ftp://example.com', 'example.com'],
    ];
  }

  /**
   * Tests the getHost method.
   *
   * @covers ::getHost
   */
  public function testGetHost() {
    $visitors_url = new VisitorsUrl('http://www.example.com');
    $this->assertEquals('example.com', $visitors_url->getHost(TRUE));

    $this->assertEquals('www.example.com', $visitors_url->getHost(FALSE));
  }

}
