<?php

declare(strict_types=1);

namespace Drupal\Tests\visitors\Unit\Plugin;

use Drupal\Tests\UnitTestCase;
use Drupal\visitors\Plugin\VisitorsEventBase;

/**
 * @coversDefaultClass \Drupal\visitors\Plugin\VisitorsEventBase
 * @group visitors
 */
class VisitorsEventBaseTest extends UnitTestCase {

  /**
   * The plugin definition.
   *
   * @var array
   */
  protected array $pluginDefinition;

  /**
   * The visitors event plugin.
   *
   * @var \Drupal\visitors\Plugin\VisitorsEventBase|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $plugin;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->pluginDefinition = [
      'id' => 'test_event',
      'label' => 'Test Event',
      'plugin' => 'test_plugin',
      'weight' => 10,
    ];

    $this->plugin = $this->createTestPlugin($this->pluginDefinition);
  }

  /**
   * Creates a test plugin instance.
   *
   * @param array $pluginDefinition
   *   The plugin definition.
   *
   * @return \Drupal\visitors\Plugin\VisitorsEventBase|\PHPUnit\Framework\MockObject\MockObject
   *   The test plugin instance.
   */
  protected function createTestPlugin(array $pluginDefinition): VisitorsEventBase {
    return new class([], 'test_event', $pluginDefinition) extends VisitorsEventBase {

      /**
       * {@inheritdoc}
       */
      public function process(array $context): ?array {
        return NULL;
      }

    };
  }

  /**
   * @covers ::getLabel
   */
  public function testGetLabel(): void {
    $this->assertEquals($this->pluginDefinition['label'], $this->plugin->getLabel());
  }

  /**
   * @covers ::getPlugin
   */
  public function testGetPlugin(): void {
    $this->assertEquals($this->pluginDefinition['plugin'], $this->plugin->getPlugin());
  }

  /**
   * @covers ::getPlugin
   */
  public function testGetPluginFallback(): void {
    // Create a plugin without the 'plugin' key in definition.
    $pluginDefinition = [
      'id' => 'test_event',
      'label' => 'Test Event',
      'weight' => 10,
    ];

    $plugin = $this->createTestPlugin($pluginDefinition);

    $this->assertEquals(get_class($plugin), $plugin->getPlugin());
  }

  /**
   * @covers ::getWeight
   */
  public function testGetWeight(): void {
    $this->assertEquals($this->pluginDefinition['weight'], $this->plugin->getWeight());
  }

  /**
   * @covers ::getWeight
   */
  public function testGetWeightDefault(): void {
    // Create a plugin without the 'weight' key in definition.
    $pluginDefinition = [
      'id' => 'test_event',
      'label' => 'Test Event',
      'plugin' => 'test_plugin',
    ];

    $plugin = $this->createTestPlugin($pluginDefinition);

    $this->assertEquals(0, $plugin->getWeight());
  }

}
