# Bidirectional Linking in VisitorsDisplayLink

The `VisitorsDisplayLink` plugin now supports bidirectional linking, allowing you to create navigation links between views that automatically point back to each other when configured properly.

## How It Works

When you configure a `VisitorsDisplayLink` on View A that links to View B, you can specify a "Bidirectional link label". If View B also has a `VisitorsDisplayLink` with a matching label, the link on View A will be overridden to point back to View A instead of View B.

This creates a seamless navigation experience where users can easily switch between related views.

## Configuration

### Step 1: Configure View A

1. Add a `VisitorsDisplayLink` area handler to View A
2. Set the **Display** to point to View B
3. Set the **Label** to something like "View Details"
4. Set the **Bidirectional link label** to something like "Back to List"

### Step 2: Configure View B

1. Add a `VisitorsDisplayLink` area handler to View B
2. Set the **Display** to point to View A
3. Set the **Label** to "Back to List" (matching the bidirectional label from View A)

## Example Scenario

**View A (List View):**
- Display: `page_1` (points to View B)
- Label: "View Details"
- Bidirectional link label: "Back to List"

**View B (Detail View):**
- Display: `page_1` (points to View A)
- Label: "Back to List"

**Result:**
- When viewing View A, the "View Details" link points to View B
- When viewing View B, the "Back to List" link points to View A
- The bidirectional linking automatically handles the navigation flow

## Technical Details

- The bidirectional linking only works when the labels match exactly
- The feature checks for `VisitorsDisplayLink` handlers in header, footer, and empty areas
- If no matching label is found, the link behaves normally
- The feature is disabled when the "Bidirectional link label" field is empty

## Use Cases

- **List to Detail Navigation**: Navigate from a list view to a detail view and back
- **Related Views**: Link between different views of the same data
- **Multi-step Workflows**: Create navigation flows between related views
- **Dashboard Navigation**: Link between different dashboard sections

## Limitations

- Only works with `VisitorsDisplayLink` handlers (not the core `DisplayLink`)
- Requires exact label matching
- Only checks header, footer, and empty areas for matching handlers
- The feature is specific to the visitors module's display link implementation
