<?php

namespace Drupal\visitors\Plugin;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\visitors\VisitorsEventPluginInterface;

/**
 * Base class for Visitors event plugins.
 */
abstract class VisitorsEventBase extends PluginBase implements VisitorsEventPluginInterface {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function getLabel(): string {
    return $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function getPlugin(): string {
    return $this->pluginDefinition['plugin'] ?? static::class;
  }

  /**
   * {@inheritdoc}
   */
  public function getWeight(): int {
    return $this->pluginDefinition['weight'] ?? 0;
  }

}
