<?php

namespace Drupal\visitors\Plugin\views\field;

use Drupal\views\Attribute\ViewsField;
use Drupal\views\Plugin\views\field\FieldPluginBase;

/**
 * Field handler to display the hour (server) of the visit.
 *
 * @ingroup views_field_handlers
 */
#[ViewsField("visitors_referer_type")]
final class RefererType extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function render($values) {
    $type = $this->getValue($values);
    switch ($type) {
      case 'direct':
        $value = $this->t('Direct Entry');
        break;

      case 'website':
        $value = $this->t('Website');
        break;

      case 'internal':
        $value = $this->t('Internal');
        break;

      case 'search_engine':
        $value = $this->t('Search Engine');
        break;

      case 'spam':
        $value = $this->t('Spam');
        break;

      case 'social_network':
        $value = $this->t('Social Network');
        break;

      case 'ai_assistant':
        $value = $this->t('AI Assistant');
        break;

      default:
        $value = $this->t('Unknown');
        break;
    }

    return $value;
  }

}
