<?php

namespace Drupal\visitors\Plugin\views\field;

use Drupal\views\Attribute\ViewsField;
use Drupal\views\Plugin\views\field\FieldPluginBase;

/**
 * Field handler to display the hour (server) of the visit.
 *
 * @ingroup views_field_handlers
 */
#[ViewsField("visitors_url_prefix")]
final class UrlPrefix extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function render($values) {
    $prefix = '';
    $value = (int) $this->getValue($values);
    switch ($value) {
      case 3:
        $prefix = 'https://www.';
        break;

      case 2:
        $prefix = 'https://';
        break;

      case 1:
        $prefix = 'http://www.';
        break;

      case 0:
      default:
        $prefix = 'http://';
        break;
    }

    return $prefix;
  }

}
