<?php

namespace Drupal\visitors;

/**
 * Detects the device type.
 *
 * @package Drupal\visitors
 */
interface VisitorsDeviceInterface {

  /**
   * Sets the device fields.
   *
   * @param array $fields
   *   The fields array.
   * @param string $user_agent
   *   The user agent string.
   * @param array|null $server
   *   The server array.
   */
  public function doDeviceFields(array &$fields, string $user_agent, ?array $server = NULL): void;

  /**
   * Gets the device type.
   *
   * @param string $class_name
   *   The class name of the library.
   *
   * @return bool
   *   The device type.
   */
  public function hasLibrary($class_name = 'DeviceDetector\ClientHints'): bool;

}
