<?php

namespace Drupal\visitors;

/**
 * Interface for visitors search engine.
 */
interface VisitorsSearchEngineInterface {

  /**
   * Match the URL to a search engine.
   *
   * @param string $url
   *   The URL to match.
   *
   * @return array|null
   *   The search engine if matched, null otherwise.
   */
  public function match(string $url): ?array;

}
