<?php

namespace Drupal\visitors;

/**
 * Interface for tracker visitors.
 */
interface VisitorsTrackerInterface {

  /**
   * The session timeout in seconds.
   *
   * It is 30 minutes.
   */
  const SESSION_TIMEOUT = 1800;

  /**
   * Writes the event.
   *
   * @param string[] $fields
   *   The fields array.
   *
   * @return int
   *   The id of row created.
   */
  public function writeEvent(array $fields): int;

  /**
   * Gets the visit id.
   *
   * @param string[] $fields
   *   The fields array.
   * @param int $request_time
   *   The request time.
   *
   * @return int
   *   The visit id.
   */
  public function getVisitId(array $fields, int $request_time): int;

  /**
   * Updates the visit.
   *
   * @param int $visit_id
   *   The visit id.
   * @param int $event_id
   *   The event id.
   * @param int $exit_time
   *   The exit time.
   * @param int|null $uid
   *   The user id.
   */
  public function updateVisit(int $visit_id, int $event_id, int $exit_time, ?int $uid);

}
