<?php

declare(strict_types=1);

namespace Drupal\visitors;

/**
 * The interface for upgrading data.
 */
interface VisitorsUpgradeInterface {

  /**
   * Get the total number of visitors.
   *
   * @return int
   *   The total number of visitors.
   */
  public function getTotal(): int;

  /**
   * Assign values to the visitors record.
   *
   * @param int $batch
   *   The batch size.
   *
   * @return array
   *   The visitors array.
   */
  public function getVisitorsRows(int $batch = 50): array;

  /**
   * Delete the visitors row.
   *
   * @param int $id
   *   The visitors id.
   */
  public function deleteVisitorsRow($id);

  /**
   * Assign values to the visit record.
   *
   * @param array $row
   *   The row array.
   *
   * @return array
   *   The visit array.
   */
  public function doVisitRecord(array $row): array;

  /**
   * Assign values to the log record.
   *
   * @param array $row
   *   The row array.
   *
   * @return array
   *   The log array.
   */
  public function doLogRecord(array $row): array;

}
