<?php

declare(strict_types=1);

namespace Drupal\Tests\visitors\Unit\Attribute;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Tests\UnitTestCase;
use Drupal\visitors\Attribute\VisitorsEvent;

/**
 * @coversDefaultClass \Drupal\visitors\Attribute\VisitorsEvent
 * @group visitors
 */
class VisitorsEventTest extends UnitTestCase {

  /**
   * Tests the constructor with minimal arguments.
   *
   * @covers ::__construct
   */
  public function testConstructMinimal(): void {
    $id = 'test_event';
    $attribute = new VisitorsEvent($id);

    $this->assertEquals($id, $attribute->id);
    $this->assertNull($attribute->label);
    $this->assertNull($attribute->plugin);
    $this->assertEmpty($attribute->variables);
    $this->assertEquals(0, $attribute->weight);
    $this->assertNull($attribute->deriver);
  }

  /**
   * Tests the constructor with all arguments.
   *
   * @covers ::__construct
   */
  public function testConstructFull(): void {
    $id = 'test_event';
    $label = 'Test Event';
    $plugin = 'test_plugin';
    $variables = ['var1', 'var2'];
    $weight = 10;
    $deriver = 'TestDeriver';

    $attribute = new VisitorsEvent(
      $id,
      $label,
      $plugin,
      $variables,
      $weight,
      $deriver,
    );

    $this->assertEquals($id, $attribute->id);
    $this->assertEquals($label, $attribute->label);
    $this->assertEquals($plugin, $attribute->plugin);
    $this->assertEquals($variables, $attribute->variables);
    $this->assertEquals($weight, $attribute->weight);
    $this->assertEquals($deriver, $attribute->deriver);
  }

  /**
   * Tests the constructor with a TranslatableMarkup label.
   *
   * @covers ::__construct
   */
  public function testConstructWithTranslatableLabel(): void {
    $id = 'test_event';
    $label = $this->createMock(TranslatableMarkup::class);

    $attribute = new VisitorsEvent($id, $label);

    $this->assertEquals($id, $attribute->id);
    $this->assertSame($label, $attribute->label);
  }

}
