<?php

declare(strict_types=1);

namespace Drupal\Tests\visitors\Unit\Plugin\views\field;

use Drupal\Tests\UnitTestCase;
use Drupal\views\ResultRow;
use Drupal\visitors\Plugin\views\field\VisitorsMonth;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Date filter form test.
 *
 * @group visitors
 * @coversDefaultClass \Drupal\visitors\Plugin\views\field\VisitorsMonth
 * @covers \Drupal\visitors\Plugin\views\field\VisitorsTimestamp
 */
class VisitorsMonthTest extends UnitTestCase {

  /**
   * The field.
   *
   * @var \Drupal\visitors\Plugin\views\field\VisitorsMonth
   */
  protected $field;

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $configFactory;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $container = new ContainerBuilder();

    $string_translation = $this->getStringTranslationStub();
    $container->set('string_translation', $string_translation);

    $this->configFactory = $this->createMock('Drupal\Core\Config\ConfigFactoryInterface');
    $container->set('config.factory', $this->configFactory);

    \Drupal::setContainer($container);

    $configuration = [];
    $plugin_id = 'visitors_month';
    $plugin_definition = [];
    $this->field = VisitorsMonth::create($container, $configuration, $plugin_id, $plugin_definition);
  }

  /**
   * Tests the getFormat method.
   *
   * @covers \Drupal\visitors\Plugin\views\field\VisitorsTimestamp::getFormat
   */
  public function testGetFormat() {
    $this->assertEquals('Ym', $this->field->getFormat());
  }

  /**
   * Tests the render method.
   *
   * @covers ::render
   */
  public function testRender() {

    $values = new ResultRow(['alias' => '20210104']);
    $this->field->field_alias = 'alias';

    $this->assertEquals("January '21", $this->field->render($values)->__toString());
  }

}
