# Search Engine Configuration

Configure search engine detection and referrer analysis for comprehensive traffic source tracking.

## Overview

The Visitors module can identify and track visits from various search engines, providing insights into your organic search traffic.

## Search Engine Detection

### Supported Search Engines
- Google, Bing, Yahoo, DuckDuckGo
- Regional search engines
- Specialized search platforms
- Custom search engine definitions

### Configuration Options
- **Enable search engine tracking**: Identify search referrals
- **Track search keywords**: Extract search terms (where available)
- **Update frequency**: How often to refresh search engine database

## Keyword Tracking

### Privacy Considerations
Modern search engines often hide search keywords for privacy. The module respects these limitations while extracting available data.

### Search Term Analysis
- Available search terms from referrers
- Search engine specific handling
- Privacy-compliant keyword extraction


For complete configuration details, see [Settings](settings.md).
