# Visitors - Drupal Web Analytics Module

Welcome to the comprehensive documentation for the Visitors module, a powerful, native Drupal web analytics tool that empowers site builders and administrators with comprehensive insights into user behavior and site performance.

## What is Visitors?

Visitors is a Drupal 10 module that records and displays detailed site visitor history, providing analytics capabilities directly within your Drupal site. It offers comprehensive tracking of user interactions, device information, geographical data, and performance metrics.

## Key Features

- **Comprehensive Analytics**: Track page views, visitor sessions, and user behavior
- **Device Detection**: Identify browsers, operating systems, and device types
- **Geographical Tracking**: Location-based analytics with GeoIP integration
- **Performance Monitoring**: Page load times and performance metrics
- **Spam Protection**: Built-in spam detection and filtering
- **Search Engine Analytics**: Track search engine referrals and bot activity
- **Views Integration**: Extensive Views plugins for custom reports
- **Blocks and Reports**: Ready-to-use blocks and comprehensive reporting
- **Charts Integration**: Visual analytics with Charts.js support

## Documentation Sections




### ⚙️ [Configuration](configuration/settings.md)
Detailed configuration guides for all module features.

- [Settings](configuration/settings.md) - Module configuration options
- [Spam Referrer Detection](configuration/spam-detection.md) - Configure spam referrer filtering
- [Search Engines](configuration/search-engines.md) - Search engine detection


### 🗄️ [Database](database/schema.md)
Database schema and data management documentation.

- [Tables](database/tables.md) - Detailed table descriptions
- [Data Migration](database/data-migration.md) - Upgrade and migration guides

### 🔌 [Integration](integration/charts.md)
Integration guides for third-party modules and libraries.

- [Charts](integration/charts.md) - Charts.js integration
- [MaxMind](integration/maxmind.md) - GeoIP2 database integration
- [Device Detector](integration/device-detector.md) - Device detection library
- [Third Party](integration/third-party.md) - Other module integrations







## Quick Links

- **Project Page**: [drupal.org/project/visitors](https://www.drupal.org/project/visitors)
- **Issue Queue**: [Issue Tracker](https://www.drupal.org/project/issues/visitors)
- **Source Code**: [GitLab Repository](https://git.drupalcode.org/project/visitors)
- **Support**: [Drupal StackExchange](https://drupal.stackexchange.com/questions/tagged/visitors)

## Version Information

- **Current Version**: 3.0.x
- **Drupal Compatibility**: 10.3+
- **PHP Compatibility**: 8.1+
- **License**: GPL-2.0-or-later

---

*This documentation is maintained by the Visitors module community. Contributions are welcome!*