<?php

namespace Drupal\visitors\Plugin\views\field;

use Drupal\views\Attribute\ViewsField;
use Drupal\views\Plugin\views\field\FieldPluginBase;

/**
 * Field handler to display bounce rate.
 */
#[ViewsField("visitors_bounce")]
class Bounce extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $this->ensureMyTable();

    $expression = "CASE WHEN {$this->tableAlias}.{$this->realField} = 1 THEN 1 ELSE 0 END";
    $this->field_alias = $this->query->addField(NULL, $expression, $this->tableAlias . '_' . $this->realField);
  }

}
