<?php

declare(strict_types=1);

namespace Drupal\visitors\Service;

use Drupal\visitors\VisitorsAiAssistantsInterface;

/**
 * Service for matching hostnames to AI assistants.
 */
final class AiAssistantsService extends HostnameMatcherServiceBase implements VisitorsAiAssistantsInterface {

  /**
   * {@inheritdoc}
   */
  protected function getConfig(): array {
    if ($this->cachedConfig === NULL) {
      $config = $this->configFactory->get('visitors.ai_assistants');
      $this->cachedConfig = $config->get('sites') ?? [];
    }

    return $this->cachedConfig;
  }

}
