<?php

declare(strict_types=1);

namespace Drupal\visitors;

/**
 * Interface for visitors social networks service.
 */
interface VisitorsSocialNetworksInterface {

  /**
   * Match a hostname to a social network.
   *
   * @param string $hostname
   *   The hostname to match.
   *
   * @return string|null
   *   The social network label if matched, null otherwise.
   */
  public function match(string $hostname): ?string;

}
