<?php

namespace Drupal\Tests\visitors\Unit;

use Drupal\Tests\UnitTestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

require_once __DIR__ . '/../../../visitors.install';

if (!defined('REQUIREMENT_WARNING')) {
  define('REQUIREMENT_WARNING', 'warning');
}

/**
 * Tests visitors_requirements().
 *
 * @group visitors
 */
class HookRequirementsTest extends UnitTestCase {

  /**
   * The device service.
   *
   * @var \Drupal\visitors\VisitorsDeviceInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $device;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $container = new ContainerBuilder();

    $this->device = $this->createMock('Drupal\visitors\VisitorsDeviceInterface');
    $container->set('visitors.device', $this->device);

    \Drupal::setContainer($container);
  }

  /**
   * Tests visitors_requirements().
   */
  public function testUpdate(): void {

    $requirements = visitors_requirements('update');
    $this->assertIsArray($requirements);
    $this->assertCount(0, $requirements);
  }

  /**
   * Tests visitors_requirements().
   */
  public function testHasLibrary(): void {

    $this->device->expects($this->once())
      ->method('hasLibrary')
      ->willReturn(TRUE);

    $requirements = visitors_requirements('runtime');
    $this->assertIsArray($requirements);
    $this->assertCount(0, $requirements);
  }

  /**
   * Tests visitors_requirements().
   */
  public function testMissingLibrary(): void {

    $this->device->expects($this->once())
      ->method('hasLibrary')
      ->willReturn(FALSE);

    $requirements = visitors_requirements('runtime');
    $this->assertIsArray($requirements);
    $this->assertCount(1, $requirements);
  }

}
