<?php

declare(strict_types=1);

namespace Drupal\Tests\visitors\Unit\Plugin\views\field;

use Drupal\Tests\UnitTestCase;
use Drupal\views\ResultRow;
use Drupal\visitors\Plugin\views\field\UrlPrefix;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Date filter form test.
 *
 * @group visitors
 * @coversDefaultClass \Drupal\visitors\Plugin\views\field\UrlPrefix
 * @covers \Drupal\visitors\Plugin\views\field\VisitorsTimestamp
 */
class UrlPrefixTest extends UnitTestCase {

  /**
   * The field.
   *
   * @var \Drupal\visitors\Plugin\views\field\UrlPrefix
   */
  protected $field;

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $configFactory;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $container = new ContainerBuilder();

    $string_translation = $this->getStringTranslationStub();
    $container->set('string_translation', $string_translation);

    $this->configFactory = $this->createMock('Drupal\Core\Config\ConfigFactoryInterface');
    $container->set('config.factory', $this->configFactory);

    \Drupal::setContainer($container);

    $configuration = [];
    $plugin_id = 'visitors_url_prefix';
    $plugin_definition = [];
    $this->field = UrlPrefix::create($container, $configuration, $plugin_id, $plugin_definition);
  }

  /**
   * Tests the render method.
   *
   * @covers ::render
   */
  public function testRenderHttp() {

    $values = new ResultRow(['prefix' => 0]);
    $this->field->field_alias = 'prefix';

    $this->assertEquals('http://', $this->field->render($values));
  }

  /**
   * Tests the render method.
   *
   * @covers ::render
   */
  public function testRenderHttpWww() {

    $values = new ResultRow(['prefix' => 1]);
    $this->field->field_alias = 'prefix';

    $this->assertEquals('http://www.', $this->field->render($values));
  }

  /**
   * Tests the render method.
   *
   * @covers ::render
   */
  public function testRenderHttps() {

    $values = new ResultRow(['prefix' => 2]);
    $this->field->field_alias = 'prefix';

    $this->assertEquals('https://', $this->field->render($values));
  }

  /**
   * Tests the render method.
   *
   * @covers ::render
   */
  public function testRenderHttpsWww() {

    $values = new ResultRow(['prefix' => 3]);
    $this->field->field_alias = 'prefix';

    $this->assertEquals('https://www.', $this->field->render($values));
  }

}
